/*****************************************************************************
*  LPC11U6x SCT demo program
*
*  Use SCT timer to generate 2 PWM signals with different
*  dutycycles @ SCT_OUT0 and SCT_OUT1
*****************************************************************************/
#include "LPC11u6x.h"

extern void SCT0_Init(void);

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)                // enable clock for IOCON
                               | (1u << 31);               // enable clock for SCT0/1

    LPC_IOCON->PIO1_25 = 0x00000083;                       // P1_25 is SCT0_IN0
    LPC_IOCON->PIO1_19 = 0x00000082;                       // P1_19 is SCT0_OUT0
    LPC_IOCON->PIO2_2  = 0x00000083;                       // P2_2  is SCT0_OUT1

    SCT0_Init();                                           // Initialize SCT0

    while (1)                                              // loop forever
    {
    }
}
